package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bRespArea;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bRespAreaBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaRespAreaExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoRespArea.xls";
		InputStream inputStream = W83bTablaRespAreaExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaRespArea = (ArrayList)contexto.get("w83bListaRespArea");
        W83bRespAreaBean respAreaBean = (W83bRespAreaBean)contexto.get("w83bRespAreaTempBean");               
        
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);               

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);               
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);               
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));               
        HashMap mapaRespArea=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);               
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1               
        HSSFCell cell = row.createCell((short)3);               
        row = sheet.getRow((short)4);               
        cell = row.getCell((short)2);               
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaRespArea.get("tituloDepEs");               
        StringBuffer tituloImagenEu =  (StringBuffer)mapaRespArea.get("tituloDepEu");               
        cell.setCellValue(tituloImagenEu.toString());               
        
        cell = row.getCell((short)6);               
        cell.setCellValue(tituloImagenEs.toString());               
        
        tituloImagenEs = (StringBuffer)mapaRespArea.get("tituloDelelegacionEs");               
        tituloImagenEu = (StringBuffer)mapaRespArea.get("tituloDelelegacionEu");               

        row = sheet.getRow((short)6);               
        cell = row.getCell((short)2);               
        cell.setCellValue(tituloImagenEu.toString());               
        
        cell = row.getCell((short)6);               
        cell.setCellValue(tituloImagenEs.toString());               
        
        row = sheet.getRow((short)9);               
        cell = row.getCell((short)0);               
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.listadoRA").toUpperCase());               
        
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.territorio"));
        cell = row.createCell(Short.parseShort("3"));
        if(!StringUtils.isEmpty(respAreaBean.getNombreTerritorio(respAreaBean.getTerritorio()))){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("3"),W83bClsConstantes.DOCE,Short.parseShort("5")));//NOPMD
	        cell.setCellValue(respAreaBean.getNombreTerritorio(respAreaBean.getTerritorio()));
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
        cell = row.createCell(Short.parseShort("8"));
        if (StringUtils.isEmpty(respAreaBean.getBaja())||W83bClsConstantes.ALTA.equals(respAreaBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());

        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());

        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.codigoResponsable"));
        cell = row.createCell(Short.parseShort("3"));
        if(StringUtils.isNotEmpty(respAreaBean.getCodigoResponsable())){
        	cell.setCellValue(W83bUtilidades.numero(respAreaBean.getCodigoResponsable().toUpperCase()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.nombreResponsable"));
        cell = row.createCell(Short.parseShort("8"));
        if(StringUtils.isNotEmpty(respAreaBean.getNombreResponsable())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("8"),W83bClsConstantes.TRECE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(respAreaBean.getNombreResponsable().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue(respAreaBean.getNombreResponsable());
        }

    	String nResp = respAreaBean.getNombreResponsable();
	    if(47<nResp.length()){
	        row.setHeightInPoints((short)(22*(nResp.length()/47)+1));
	    }

        
        row = sheet.getRow(Short.parseShort("14")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.descPerfil"));
        cell = row.createCell(Short.parseShort("3"));
        if(W83bClsConstantes.CONSTANTE_EUSKARA.equalsIgnoreCase(idioma)){
	        if(StringUtils.isNotEmpty(respAreaBean.getPerfilDescEusk())){
	        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("3"),W83bClsConstantes.CATORCE,Short.parseShort("7")));//NOPMD
	        	cell.setCellValue(respAreaBean.getPerfilDescEusk().toUpperCase());
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
		}else{
			if(StringUtils.isNotEmpty(respAreaBean.getPerfilDesc())){
				sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("3"),W83bClsConstantes.CATORCE,Short.parseShort("7")));//NOPMD
	        	cell.setCellValue(respAreaBean.getPerfilDesc().toUpperCase());
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
		}

        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("17")); // Creacin de la fila 1
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.territorio"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 2 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.codigoResponsable"));
        
        cell = row.getCell(Short.parseShort("3")); // Creacin de la columna 3 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.nombreResponsable"));
        
        cell = row.getCell(Short.parseShort("7")); // Creacin de la columna 4 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.descPerfil"));
        
        cell = row.getCell(Short.parseShort("9")); // Creacin de la columna 4 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.respArea.descPerfilEuskera"));
        
        String pCod = "";
        for(int i=0;i<listaRespArea.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+i); // Creacin de la fila 1//NOPMD
        	
        	//Territotio
        	cell = row.createCell(Short.parseShort("0")); 
        	W83bRespAreaBean respBean = (W83bRespAreaBean) listaRespArea.get(i);
        	pCod = respBean.getNombreTerritorio(respBean.getTerritorio());
        	
        	
        	if(StringUtils.isNotEmpty(((W83bRespAreaBean)listaRespArea.get(i)).getTerritorio())){
        		if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(((W83bRespAreaBean)listaRespArea.get(i)).getTerritorio())){
        			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.servCentrales",idioma).toUpperCase());
        		}else{
        			if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(((W83bRespAreaBean)listaRespArea.get(i)).getTerritorio())){
            			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.servCentrales",idioma).toUpperCase());
            		}else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(((W83bRespAreaBean)listaRespArea.get(i)).getTerritorio())){
            			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.gipuzkoa",idioma).toUpperCase());
        			}else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(((W83bRespAreaBean)listaRespArea.get(i)).getTerritorio())){
        				cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.bizkaia",idioma).toUpperCase());
        			}else{
        				cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.alava",idioma).toUpperCase());
        			}
        		}
        	}else{
        		cell.setCellValue("");
        	}
        	if(StringUtils.isNotEmpty(pCod)){
        		cell.setCellValue(pCod);
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("1"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("2")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bRespAreaBean)listaRespArea.get(i)).getCodigoResponsable())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bRespAreaBean)listaRespArea.get(i)).getCodigoResponsable()));
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("3"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("3"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("6")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bRespAreaBean)listaRespArea.get(i)).getNombreResponsable())){
        		cell.setCellValue(((W83bRespAreaBean)listaRespArea.get(i)).getNombreResponsable().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("5")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("6"));
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("7"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("7"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("8")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bRespAreaBean)listaRespArea.get(i)).getPerfilDesc())){
        		cell.setCellValue(((W83bRespAreaBean)listaRespArea.get(i)).getPerfilDesc().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("9"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("9"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bRespAreaBean)listaRespArea.get(i)).getPerfilDescEusk())){
        		cell.setCellValue(((W83bRespAreaBean)listaRespArea.get(i)).getPerfilDescEusk().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoRespArea.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
